/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWFByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInProcQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInSysQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;

public abstract class VWAdminWOTableModel
extends VWAdminResultTableModelBase {
    protected abstract void startTheQuery() throws Exception;

    protected abstract void retrieveWorkObjects() throws Exception;

    protected abstract void getExposedFieldsDefinition() throws Exception;

    public VWAdminWOTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
    }

    public void getNextBatch() throws Exception {
        this.retrieveWorkObjects();
        this.buildAvailableColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            if (!this.isFieldEditable(rowIndex, columnIndex)) {
                return false;
            }
            Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
            if (rowData != null) {
                VWAdminFieldsTableData fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex);
                if (fieldData == null) {
                    return false;
                }
                if (VWStringUtils.compare(fieldData.getAuthoredName(), "F_Comment") == 0) {
                    return false;
                }
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(rowIndex);
                return woData.getLockedStatus() == 1;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getObjectAt(rowIndex, columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setCellElement(aValue, rowIndex, columnIndex);
    }

    public Class getColumnClass(int index) {
        if (index == 0) {
            return String.class;
        }
        if (index == COL_EXCEPTION_INDICATOR) {
            return ImageIcon.class;
        }
        if (index == COL_DUE_STATUS) {
            return ImageIcon.class;
        }
        if (index == COL_DIRTY) {
            return ImageIcon.class;
        }
        if (index == COL_LOCK_STATUS) {
            return ImageIcon.class;
        }
        if ((this instanceof VWAdminWFObjByWOInRosterTableModel || this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) && index == COL_TRACKER) {
            return ImageIcon.class;
        }
        return String.class;
    }

    public Object getObjectAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            if (columnIndex == 0 || columnIndex == COL_EXCEPTION_INDICATOR || columnIndex == COL_DUE_STATUS || columnIndex == COL_DIRTY || columnIndex == COL_LOCK_STATUS) {
                return rowData.elementAt(columnIndex);
            }
            if (this instanceof VWAdminWFObjByWOInRosterTableModel ? columnIndex == COL_QUEUE_NAME || columnIndex == COL_TRACKER : (this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) && columnIndex == COL_TRACKER) {
                return rowData.elementAt(columnIndex);
            }
            VWAdminFieldsTableData fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex);
            return fieldData;
        }
        return null;
    }

    protected void refreshTable() {
        try {
            this.retrieveColumnNames();
            this.retrieveRowData();
            this.fireTableChanged(new TableModelEvent(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    protected void initTable() throws Exception {
        if (!this.validateIndex()) {
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), VWResource.s_F_WobNumError, VWResource.s_F_WobNumIndex, 0);
            return;
        }
        this.startTheQuery();
        this.getFirstBatch();
    }

    protected void getFirstBatch() throws Exception {
        this.retrieveWorkObjects();
        this.buildAvailableColumnsList();
        this.buildSelectedColumnsList();
        this.retrieveColumnNames();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected Object getObjectAt(int rowIndex) {
        VWAdminWorkObjectTableData obj = null;
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        obj = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(rowIndex);
        return obj;
    }

    protected Object getCellElement(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            if (columnIndex == 0 || columnIndex == COL_EXCEPTION_INDICATOR || columnIndex == COL_DUE_STATUS || columnIndex == COL_DIRTY || columnIndex == COL_LOCK_STATUS) {
                return rowData.elementAt(columnIndex);
            }
            if (this instanceof VWAdminWFObjByWOInRosterTableModel ? columnIndex == COL_QUEUE_NAME || columnIndex == COL_TRACKER : (this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) && columnIndex == COL_TRACKER) {
                return rowData.elementAt(columnIndex);
            }
            VWAdminFieldsTableData fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex);
            if (fieldData != null) {
                return fieldData.getValue();
            }
        }
        return null;
    }

    protected void setCellElement(Object aValue, int rowIndex, int columnIndex) {
        VWAdminFieldsTableData fieldData;
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null && !aValue.equals((fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex)).getValue())) {
            fieldData.setValue(aValue);
            fieldData.fireFieldChangeEvent(rowIndex);
        }
    }

    protected void retrieveRowData() {
        this.retrieveRowDataForWorkObject();
    }

    protected void retrieveRowData(int rowIndex) {
        this.retrieveRowDataForWorkObject(rowIndex);
    }

    protected void retrieveColumnNames() {
        try {
            if (this.m_headers != null) {
                this.m_headers.removeAllElements();
            }
            if (this.m_objectCache.size() <= 0) {
                return;
            }
            this.m_startIndex = 0;
            if (this.m_selectedColumns.size() > 0) {
                this.m_headers.addElement(" ");
                ++this.m_startIndex;
                if (this instanceof VWAdminWFObjByWOInRosterTableModel || this instanceof VWAdminWFObjByWOInQueueTableModel) {
                    this.m_headers.addElement(" ");
                    ++this.m_startIndex;
                }
                if (!(this instanceof VWAdminWFByWOInRosterTableModel)) {
                    this.m_headers.addElement(" ");
                    ++this.m_startIndex;
                }
                if (this instanceof VWAdminWFObjByWOInRosterTableModel || this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) {
                    this.m_headers.addElement(" ");
                    ++this.m_startIndex;
                }
                this.m_headers.addElement(" ");
                ++this.m_startIndex;
                this.m_headers.addElement(" ");
                ++this.m_startIndex;
                if (this instanceof VWAdminWFObjByWOInRosterTableModel) {
                    this.m_headers.addElement(VWResource.s_queue);
                    ++this.m_startIndex;
                }
            }
            for (int i = 0; i < this.m_selectedColumns.size(); ++i) {
                this.m_headers.addElement((String)this.m_selectedColumns.elementAt(i));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void buildAvailableColumnsList() {
        VWDataField[] vwDataFields = null;
        VWWorkObject curWorkObject = null;
        try {
            if (this.m_availableColumns != null) {
                this.m_availableColumns.removeAllElements();
            }
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
                curWorkObject = woData.getWob();
                vwDataFields = curWorkObject.getDataFields(767, 3);
                String name = null;
                for (int j = 0; j < vwDataFields.length; ++j) {
                    name = vwDataFields[j].getName();
                    if (this.isInVector(name, this.m_availableColumns)) continue;
                    this.m_availableColumns.addElement(name);
                    this.m_availableFields.addElement(vwDataFields[j]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void buildSelectedColumnsList() {
        try {
            int i;
            if (this.m_selectedColumns != null) {
                this.m_selectedColumns.removeAllElements();
            }
            if (this.m_selectedColumnsFromQuery != null) {
                for (i = 0; i < this.m_selectedColumnsFromQuery.length; ++i) {
                    if (!this.isInVector(this.m_selectedColumnsFromQuery[i], this.m_availableColumns)) continue;
                    this.m_selectedColumns.addElement(this.m_selectedColumnsFromQuery[i]);
                }
            }
            for (i = 0; i < this.m_availableColumns.size(); ++i) {
                VWDataField fieldDef;
                String aField = (String)this.m_availableColumns.elementAt(i);
                if (this.isInVector(aField, this.m_selectedColumns) || this.isInExposedFieldDefinitions(aField, this.m_vwFieldDefinitions) || (fieldDef = this.getDataField(aField, this.m_availableFields)) == null) continue;
                String authoredName = fieldDef.getAuthoredName();
                if (authoredName.length() >= 2) {
                    String smallString = authoredName.substring(0, 2);
                    if (VWStringUtils.compareIgnoreCase(smallString, "F_") != 0) {
                        this.m_selectedColumns.addElement(aField);
                        continue;
                    }
                } else {
                    this.m_selectedColumns.addElement(aField);
                    continue;
                }
                if (VWStringUtils.compare(authoredName, "F_Originator") != 0 && VWStringUtils.compare(authoredName, "F_WobNum") != 0 && VWStringUtils.compare(authoredName, "F_WorkFlowNumber") != 0 && VWStringUtils.compare(authoredName, "F_BoundUser") != 0 && VWStringUtils.compare(authoredName, "F_LockUser") != 0 && VWStringUtils.compare(authoredName, "F_StartTime") != 0 && VWStringUtils.compare(authoredName, "F_Subject") != 0 && VWStringUtils.compare(authoredName, "F_Operation") != 0 && VWStringUtils.compare(authoredName, "F_Comment") != 0 && VWStringUtils.compare(authoredName, "F_Response") != 0 && VWStringUtils.compare(authoredName, "F_LockTime") != 0) continue;
                this.m_selectedColumns.addElement(aField);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void refreshWorkObjects() {
        VWWorkObject curWorkObject = null;
        try {
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
                curWorkObject = woData.getWob();
                int lockStatus = woData.getLockedStatus();
                if (lockStatus == 1) {
                    curWorkObject.doRefresh(true, true);
                    continue;
                }
                curWorkObject.doRefresh(false, false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

